/* ==================================================================
File        : fmv.hlsl
Author      : Vassilis Poulopoulos
Date        : 29/11/2007 22:42:04
Format      : D3D9 HLSL
Description : FMV related shaders

================================================================== */

// Include shared header file which includes declarations such as:
// - viewProj
// - world
// - kTint
#include "VertexShaderSemantics.fx"
#define g_ViewProj		viewProj
#define g_World			world
#define g_kTint			kTint
#define g_UvOffset01	uvOffset01

struct VS_IN
{
	float4 position		: POSITION;
	float2 uvSet0		: TEXCOORD0;
	float4 colorSet0	: COLOR;
	float4 normal		: NORMAL;
};

struct VS_OUT
{
	float4 position		: POSITION;
	float2 uvSet0		: TEXCOORD0;
	float4 colorSet0	: COLOR;
};

//_________________________________________________________________________________________________

VS_OUT FMV_2D_vx(VS_IN input)
{
	VS_OUT OUT;

	OUT.position	= input.position;
	OUT.uvSet0		= ((input.uvSet0 - float2(0.5,0.5)) * g_UvOffset01.zw) + float2(0.5,0.5);
	OUT.colorSet0	= float4(input.colorSet0.rgb,input.normal.a) * g_kTint;

	return OUT;
}

//_________________________________________________________________________________________________

VS_OUT FMV_3D_vx(VS_IN input)
{
	VS_OUT OUT;

	OUT.position	= mul(mul(input.position, g_World), g_ViewProj);
	OUT.uvSet0		= ((input.uvSet0 - float2(0.5,0.5)) * g_UvOffset01.zw) + float2(0.5,0.5);
	OUT.colorSet0	= float4(input.colorSet0.rgb,input.normal.a) * g_kTint;

	return OUT;
}

//_________________________________________________________________________________________________

//@:-texformat layer0_sampler RGBA8
//@:-texformat layer1_sampler RGBA8
//@:-texformat layer2_sampler RGBA8

sampler2D layer0_sampler : register(s0);
sampler2D layer1_sampler : register(s1);
sampler2D layer2_sampler : register(s2);
float4  tor    	: register(c0);
float4  tog    	: register(c1);
float4  tob    	: register(c2);
float4  consts	: register(c3);

float4 FMV_BinkDecode_px(VS_OUT IN) : COLOR
{
	//const float4 crc = { 1.595794678f, -0.813476563f, 0, 0 };
	//const float4 crb = { 0, -0.391448975f, 2.017822266f, 0 };
	//const float4 adj = { -0.87065506f, 0.529705048f, -1.081668854f, 0 };

	const float4 crc = { 1.164123535f,  1.595794678f,  0.0f,         -0.87065506f};
	const float4 crb = { 1.164123535f, -0.813476563f, -0.391448975f,  0.529705048f};
	const float4 adj = { 1.164123535f,  0.0f,          2.017822266f, -1.081668854f};

	float y = tex2D(layer0_sampler,  IN.uvSet0).x;
	float cr = tex2D(layer1_sampler, IN.uvSet0).x;
	float cb = tex2D(layer2_sampler, IN.uvSet0).x;
	
	float4 c = {y, cr, cb, 1.0};
	float4 p;

	p.x = dot( crc, c );
	p.y = dot( crb, c );
	p.z = dot( adj, c );
	p.w = 1.0;
	
	return p * IN.colorSet0 * 2;
}

//________________________________________________________________________________________________
//@:-texformat layer0_samp RGBA8
//@:-texformat layer1_samp RGBA8
//@:-texformat layer2_samp RGBA8

sampler2D layer0_samp : register(s0);
sampler2D layer1_samp : register(s1);
sampler2D layer2_samp : register(s2);														
																			
float4 csbh = float4(1, 1, 0, 0); // contrast, saturation, brightness, hue	
																			
float4 FMV_ChromaDecode_px(VS_OUT IN) : COLOR
{																			
#if 0
	float4 c;																
																			
	float y = tex2D(layer0_samp, IN.uvSet0);												
	float cb = tex2D(layer1_samp, IN.uvSet0) - 0.5;										
	float cr = tex2D(layer2_samp, IN.uvSet0) - 0.5;										
																			
	y	= (y * csbh.x) + csbh.z;												
	cb	= (cb * cos(csbh.w) + cb * sin(csbh.w)) * csbh.x * csbh.y;			
	cr	= (cr * cos(csbh.w) - cr * sin(csbh.w)) * csbh.x * csbh.y;			
																			
	float r	= saturate(y + cr * 1.402);										
	float g = saturate(y - cr * 0.71414 - cb * 0.34414);					
	float b = saturate(y + cb * 1.772);										
	c.a = 1.0f;																
																		
	// sepia tone map														
// 	if (tc.x > 0.5)														
// 	{																	
// 		c.r = (r * 0.393) + (g * 0.769) + (b * 0.189);					
// 		c.g = (r * 0.349) + (g * 0.686) + (b * 0.168);					
// 		c.b = (r * 0.272) + (g * 0.534) + (b * 0.131);					
// 	}																	
// 	else																
 	{																		
		c.r = r;															
		c.g = g;															
		c.b = b;															
	}																		
																			
	return c * IN.colorSet0 * 2;																
#endif
	//const float4 crc = { 1.595794678f, -0.813476563f, 0, 0 };
	//const float4 crb = { 0, -0.391448975f, 2.017822266f, 0 };
	//const float4 adj = { -0.87065506f, 0.529705048f, -1.081668854f, 0 };

	const float4 crc = { 1.164123535f,  1.595794678f,  0.0f,         -0.87065506f};
	const float4 crb = { 1.164123535f, -0.813476563f, -0.391448975f,  0.529705048f};
	const float4 adj = { 1.164123535f,  0.0f,          2.017822266f, -1.081668854f};

	float y = tex2D(layer0_sampler,  IN.uvSet0).x;
	float cr = tex2D(layer1_sampler, IN.uvSet0).x;
	float cb = tex2D(layer2_sampler, IN.uvSet0).x;
	
	float4 c = {y, cr, cb, 1.0};
	float4 p;

	p.x = dot( crc, c );
	p.y = dot( crb, c );
	p.z = dot( adj, c );
	p.w = 1.0;
	
	return p * IN.colorSet0 * 2;
}																			

//_________________________________________________________________________________________________

float4 FMV_SM1_px(VS_OUT IN) : COLOR
{
	float3 rgb = tex2D(layer0_sampler, IN.uvSet0).rgb;
	
	return float4(rgb, 1) * IN.colorSet0 * 2;
}

//_________________________________________________________________________________________________
